﻿/*
Copyright (c) 2009 boblemarin

Permission is hereby granted, free of charge, to any person
obtaining a copy of this software and associated documentation
files (the "Software"), to deal in the Software without
restriction, including without limitation the rights to use,
copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following
conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.
*/
package be.minimal.utils {
	import flash.events.KeyboardEvent;
	import flash.display.Stage;
	
	public class KeyObject {
		private var _keysHeld:Object;
		
		public function KeyObject(stage:Stage) {
			_keysHeld = new Object();
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP,   onKeyUp  );
		}
		
		private function onKeyDown(event:KeyboardEvent):void {
			_keysHeld[event.keyCode] = true;
		}
		
		private function onKeyUp(event:KeyboardEvent):void {
			delete _keysHeld[event.keyCode];
		}
		
		public function isDown(keyCode:int):Boolean {
			return _keysHeld[keyCode] ? _keysHeld[keyCode] : false;
		}
		
	}
	
}
