﻿package com.actionsnippet.qbox.objects{
	
	import flash.display.*
	import flash.events.*;
	
	import com.actionsnippet.qbox.*
	
	
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import Box2D.Dynamics.Joints.*;
	
		/**
	CircleObject is a subclass of {@link com.actionsnippet.qbox.QuickObject} and should only be instantiated with the {@link com.actionsnippet.qbox.QuickBox2D#addCircle()} method.
	
	@author Zevan Rosser
	@version 1.0
	*/
	public class CircleObject extends QuickObject {
				   
		public function CircleObject(qbox:QuickBox2D, params:Object){
			super(qbox, params);
		}
		
		override protected function defaultParams(p:Object):void{
			
		}
		
		protected override function build():void{
			 
			var p:Object = params;
			
			
			var circDef:b2CircleDef = new b2CircleDef();
			shapeDef = circDef;
			
			 if (p.skin is DisplayObject){
				bodyDef.userData = p.skin;
				if (!p.radius){
				  p.radius = p.skin.width/60;
				}
			 }
			 if (!p.radius) p.radius = .5;
			
			circDef.radius = p.radius;
			circDef.density = p.density;
			circDef.friction = p.friction;
			circDef.restitution = p.restitution;
			circDef.filter.maskBits = p.maskBits;
			circDef.filter.categoryBits = p.categoryBits;
			circDef.filter.groupIndex = p.groupIndex;
			 
			 
			if (p.skin is Class){
			    bodyDef.userData = new p.skin();
				 
				if (p.scaleSkin == true){
					bodyDef.userData.width= p.radius * 60;
					bodyDef.userData.height= p.radius* 60;
				}
			
			}else if (p.skin is DisplayObject){
			}else if(p.skin != "none"){
				bodyDef.userData = new Sprite();
				with(bodyDef.userData.graphics){
					lineStyle(p.lineThickness,p.lineColor, p.lineAlpha);
					beginFill(p.fillColor, p.fillAlpha);
					
					drawCircle(0,0,p.radius * 30)
				}
				if (p.scaleSkin == true){
				  bodyDef.userData.width = p.radius * 60;
			      bodyDef.userData.height = p.radius* 60;
				}
			}
			
			
			body = w.CreateBody(bodyDef);
			shape = body.CreateShape(circDef);
			 
		}
	}
}