﻿package com.actionsnippet.qbox.objects{
	
	import flash.display.*
	import flash.events.*;
	
	import com.actionsnippet.qbox.*
	
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import Box2D.Dynamics.Joints.*;
	
	/**
	GroupObject is a subclass of {@link com.actionsnippet.qbox.QuickObject} and should only be instantiated with the {@link com.actionsnippet.qbox.QuickBox2D#addGroup()} method.
	
	@author Zevan Rosser
	@version 1.0
	*/
	public class GroupObject extends QuickObject {
				   
		public function GroupObject(qbox:QuickBox2D, params:Object){
			super(qbox, params);
		}
		
		override protected function defaultParams(p:Object):void{
			p.objects = [];
		}
		
 
		override protected function build():void{
			var p:Object = params;
			 
			body =  qbox.w.CreateBody(bodyDef);
			
			if (p.skin is Class){
			    bodyDef.userData = new p.skin();
				if (p.scaleSkin == true){
					bodyDef.userData.width=p.width * 30;
					bodyDef.userData.height=p.height * 30;
				}
			}else
		    if (p.skin is DisplayObject){
				bodyDef.userData = p.skin;
				if (p.scaleSkin == true){
					bodyDef.userData.width=p.width * 30;
					bodyDef.userData.height=p.height * 30;
				}
				 
			}else if (p.skin != "none"){
			 bodyDef.userData = new Sprite();
			}
			body.m_userData = bodyDef.userData;
			
			shape = [];
			var shapeIndex:int = 0;
			for (var i:int = 0; i<p.objects.length; i++){
				//trace("z", p.objects[i].shapeDef is b2ShapeDef);
				var o:QuickObject = p.objects[i];
				
				var sd:* = o.shapeDef;
				if (sd is b2ShapeDef){
					if (sd is b2CircleDef){
						sd.localPosition.Set(o.x, o.y);
					}else if (sd is b2PolygonDef){
						
						sd.SetAsOrientedBox(o.params.width / 2, o.params.height / 2, new b2Vec2(o.x, o.y), o.angle);
						  
					}
				   shape[shapeIndex++] = body.CreateShape(sd);
				   
				}else if (sd is Array){
					 
						for (var k:int = 0; k < sd.length; k++){
							var def:b2PolygonDef = sd[k];
							var leng:Number = o.params.verts[k].length / 2;
							for (var h:int = 0; h<leng; h++){
								//trace(def.vertices[h].x, def.vertices[h].y);
								def.vertices[h].Add(new b2Vec2(o.x, o.y))
							}
							 shape[shapeIndex++] = body.CreateShape(def);
						}
					}
				
				// take the display objects fromt the other QuickObjects and 
				// add them to the userData of the group
				// if there is a skin for this whole group, don't add the display object from the other elements
				if (o.userData is DisplayObject && !p.skin){
					var dp:DisplayObject = o.userData;
					dp.x = o.x * 30;
					dp.y = o.y * 30;
					dp.rotation = o.angle / Math.PI * 180;
					o.fullDestroy();
					body.m_userData.addChild(dp);
				}else{
					o.fullDestroy();
				}
			}
			body.SetMassFromShapes();
			
			//angle = p.angle;
			
			/*for (i = 0; i<p.objects.length; i++){
				o = p.objects[i];
				if (o.userData is DisplayObject){
					var dp = o.userData;
					dp.x = o.x * 30;
					dp.y = o.y * 30;
					o.destroy();
					body.m_userData.addChild(dp);
			  
				}
			}*/
			 
			
		}
	}
}