﻿package com.actionsnippet.qbox.objects{
	
	import flash.display.*
	import flash.events.*;
	
	import com.actionsnippet.qbox.*
	
	import Box2D.Dynamics.*;
	import Box2D.Collision.*;
	import Box2D.Collision.Shapes.*;
	import Box2D.Common.Math.*;
	import Box2D.Dynamics.Joints.*;
	
	/**
	JointObject is a subclass of {@link com.actionsnippet.qbox.QuickObject} and should only be instantiated with the {@link com.actionsnippet.qbox.QuickBox2D#addJoint()} method.
	
	@author Zevan Rosser
	@version 1.0
	*/
	public class JointObject extends QuickObject {
				   
		private var jointDef:b2JointDef
		public function JointObject(qbox:QuickBox2D, params:Object){
			super(qbox, params);
		}
		
		override public function get userData():*{
			 
			return jointDef.userData;
		}
		
		override public function set userData(object:*):*{
			jointDef.userData = object;
		}
		
		override protected function defaultParams(p:Object):void{
			p.a = null;
			p.b = null;
			//p.vecA = new b2Vec2(0, 0);
			//p.vecB = new b2Vec2(1, 1);
			// distance
			p.frequencyHz = 0;
			p.dampingRatio = 0;
			p.length = null;
			p.collideConnected = true;
			// revolute
			p.referenceAngle =  0
			p.enableLimit=  false
			p.upperAngle=  0
			p.lowerAngle=  0
			p.enableMotor=  false
			p.motorSpeed=  0
			p.maxMotorTorque=  0
			//
			p.lowerTranslation = 0;
			p.upperTrasnlation = 0;
			p.maxMotorForce = 0;
			//
			p.ratio = 1;

		}
		
		override protected function build():void{
			var p:Object = params;
			
			if (p.a == null || p.b == null){
				throw new Error("your jointDef must have b2Body instances for its a and b properties")
			}
			
			
			if (p.type == null || p.type == "distance"){
			   buildDistanceJoint(p);
			}else if (p.type == "revolute"){
			   buildRevoluteJoint(p);
			}else if (p.type == "prismatic"){
			   buildPrismaticJoint(p);
			}else if (p.type == "pulley"){
			   buildPullyJoint(p);
			}else if (p.type == "gear"){
			   buildGearJoint(p);
			}
			
			
			if (p.skin){
				userData = new p.skin();
				if (!(userData is MovieClip)){
					throw new Error("Sorry, joint skins must be dynamic. If you're using a Sprite, just use a MovieClip instead.");
				}
				userData.startWidth = userData.width;
				userData.startHeight = userData.height;
				userData.p = params;
			 }else if (p.skin == "none"){
				userData = params; 
			 }else{
				userData = params; 
			 }
			
			 
			jointDef.collideConnected = p.collideConnected;
			joint = w.CreateJoint(jointDef);
		}
		//
		private function buildGearJoint(p:Object):void{
			
			jointDef = new b2GearJointDef();
			var j:b2GearJointDef = b2GearJointDef(jointDef);
			j.userData = null;
			j.body1 = p.a;
			j.body2 = p.b;
			j.joint1 = p.joint1;
			j.joint2 = p.joint2;
			j.ratio = p.ratio;
		}
		private function buildPullyJoint(p:Object):void{
			 
			var groundAnchor1:b2Vec2;
			var groundAnchor2:b2Vec2;
			var anchor1:b2Vec2;
			var anchor2:b2Vec2;
			
			if (p.anchor1){
				anchor1 = p.anchor1;
			}else{
				anchor1 = p.a.GetWorldCenter();
			}
			
			if (p.anchor2){
				anchor2 = p.anchor2;
			}else{
				anchor2 = p.b.GetWorldCenter();
			}
			if (p.groundAnchor1){
				groundAnchor1 = p.groundAnchor1;
			}else{
				groundAnchor1 = new b2Vec2(anchor1.x, 0);
			}
			if (p.groundAnchor2){
				groundAnchor2 = p.groundAnchor2;
			}else{
				groundAnchor2 = new b2Vec2(anchor2.x, 0);
			}
			
			
			jointDef = new b2PulleyJointDef();
			jointDef.userData = null;
			 var j:b2PulleyJointDef= b2PulleyJointDef(jointDef);
			j.Initialize(p.a, p.b, groundAnchor1, groundAnchor2, anchor1, anchor2, p.ratio);
			if (p.maxLength1) j.maxLength1 = p.maxLength1;
			if (p.maxLength2) j.maxLength2 = p.maxLength2;
			if (p.length1) j.length1 = p.length1
			if (p.length2) j.length2 = p.length2
		}
		private function buildPrismaticJoint(p:Object):void{
			
			
		    var axis:b2Vec2 = new b2Vec2(0, 1);
			var anchor:b2Vec2 = p.a.GetWorldCenter();
			
			if (p.anchor){
				anchor = p.anchor;
			}else
			if (!p.x1 && !p.y1){
				p.x1 = anchor.x
				p.y1 = anchor.y
			}else{
				anchor.x = p.x1;
				anchor.y = p.y1;
			}
			
			if (p.axis){
				axis = p.axis;
			}else
			if (!p.x2 && !p.y2){
				p.x1 = axis.x
				p.y1 = axis.y
			}else{
				axis.x = p.x1;
				axis.y = p.y1;
			}
			
			
			jointDef = new b2PrismaticJointDef();
			jointDef.userData = null;
			var j:b2PrismaticJointDef= b2PrismaticJointDef(jointDef);
			j.Initialize(p.a, p.b, anchor, axis);
			
			j.referenceAngle = p.referenceAngle;
			j.enableLimit = p.enableLimit;
			j.upperTranslation = p.upperTranslation;
			j.lowerTranslation = p.lowerTranslation;
	        j.enableMotor = p.enableMotor;
		    j.motorSpeed = p.motorSpeed;
		    j.maxMotorForce = p.maxMotorForce;
		}
		
		private function buildRevoluteJoint(p:Object):void{
			var loc:b2Vec2;
			
		    loc = p.a.GetWorldCenter();
			if (!p.x1 && !p.y1){
				p.x1 = loc.x
				p.y1 = loc.y
			}else{
				loc.x = p.x1;
				loc.y = p.y1;
			}
			if (p.vecA == null){
				p.vecA = loc;
			}
			if (p.anchor){
				p.vecA = p.anchor;
			}
			
			  jointDef = new b2RevoluteJointDef();
			  jointDef.userData = null;
			var rj:b2RevoluteJointDef= b2RevoluteJointDef(jointDef);
			rj.Initialize(p.a, p.b, p.vecA);
			
			 rj.referenceAngle = p.referenceAngle;
			rj.enableLimit = p.enableLimit;
			  rj.upperAngle = p.upperAngle;
			rj.lowerAngle = p.lowerAngle;
			  rj.enableMotor = p.enableMotor;
			  rj.motorSpeed = p.motorSpeed;
			  rj.maxMotorTorque = p.maxMotorTorque;
		}
		private function buildDistanceJoint(p:Object):void{
			
			var loc:b2Vec2;
			if (!p.x1 && !p.y1){
				loc = p.a.GetWorldCenter();
				p.x1 = loc.x
				p.y1 = loc.y
			}
			if (!p.x2 && !p.y2){
				loc = p.b.GetWorldCenter();
				p.x2 = loc.x;
				p.y2 = loc.y;
			}
			
			if (p.vecA == null){
				p.vecA = new b2Vec2(p.x1, p.y1);
			}
			if (p.vecB == null){
				p.vecB = new b2Vec2(p.x2, p.y2);
			}
			
			
			 jointDef = new b2DistanceJointDef();
			var dj:b2DistanceJointDef= b2DistanceJointDef(jointDef);
			 
			
			 dj.Initialize(p.a, p.b, p.vecA, p.vecB);
			 dj.frequencyHz = p.frequencyHz;
			 dj.dampingRatio = p.dampingRatio;
			 if (p.length){
				dj.length = p.length;  
			 }
		}
	}
}